package org.krosai.core.model


interface ModelResponse<T : ModelResult<*>> {

    /**
     * Retrieves the result of the AI model.
     * @return the result generated by the AI model
     */
    val result: T

    /**
     * Retrieves the list of generated outputs by the AI model.
     * @return the list of generated outputs
     */
    val results: List<T>

    /**
     * Retrieves the response metadata associated with the AI model's response.
     * @return the response metadata
     */
    val responseMetadata: ResponseMetadata

}

/**
 * Interface representing metadata associated with an AI model's response.
 *
 * @author Mark Pollack
 * @since 1.0.0
 */
interface ResponseMetadata : Map<String, Any> {

    object Null : ResponseMetadata, Map<String, Any> by emptyMap()

}
