package org.krproject.ocean.skeletons.fish.batch.api.explore;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 根据JobName获取所有执行信息请求.
 * 
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class FishBatchGetJobExecutionsByJobNameRequest extends FishBatchExploreRequest<FishBatchGetJobExecutionsByJobNameResponse> {
	
	//JobName
	@NotEmpty(message = "JobName不能为空")
	private String jobName;
	
	// job实例起始值
	private int jobStart = 0;
	
	// job实例个数
	private int jobCount = 20;
	
}
