package org.krproject.ocean.skeletons.fish.batch.api.explore;

import java.util.List;

import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;


/**
 * 根据JobName获取所有执行信息响应.
 * 
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class FishBatchGetJobExecutionsByJobNameResponse extends FishBatchExploreResponse {
	
	// Job实例总数
	private Integer jobTotalSize;
	
	// Job实例得执行信息集合
	private List<FishBatchJobExecution> jobExecutions;
	
}
