package org.krproject.ocean.skeletons.fish.batch.api.explore;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;


/**
 * 获取某个job所有实例请求.
 * 
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class FishBatchGetJobInstancesRequest extends FishBatchExploreRequest<FishBatchGetJobInstancesResponse> {
	
	//jobName
	@NotEmpty(message = "JobName不能为空")
	private String jobName;
	
	private int start = 0;
	
	private int count = 20;

}
