package org.krproject.ocean.skeletons.fish.batch.api.explore;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 获取Step执行信息请求.
 * 
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class FishBatchGetStepExecutionRequest extends FishBatchExploreRequest<FishBatchGetStepExecutionResponse> {
	
	//JobExecutionId
	@NotNull(message = "JobExecutionId不能为空")
	private Long jobExecutionId;
	
	//StepExecutionId
	@NotNull(message = "stepExecutionId不能为空")
	private Long stepExecutionId;
	
}
