package org.krproject.ocean.skeletons.fish.batch.api.operate;

import javax.validation.constraints.NotEmpty;

import org.krproject.ocean.skeletons.fish.batch.api.FishBatchRequest;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;


/**
 * Batch操作类请求抽象类.
 * 
 * @param <T> 响应
 * 
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public abstract class FishBatchOperateRequest<T extends FishBatchOperateResponse> extends FishBatchRequest<T> {
	
	//批量操作人
	@NotEmpty(message = "批量操作人不能为空")
	private String operator;
	
	//批量名
	private String jobName;
	
	//批量执行ID
	private Long jobExecutionId;

}
