package org.krproject.ocean.skeletons.fish.batch.endpoint;

import java.lang.reflect.ParameterizedType;

import org.krproject.ocean.vitamins.batch.exception.BatchException;

/**
 * fish批量处理器抽象类.
 * 
 * @param <REQ> 请求泛型
 * @param <RESP> 响应泛型
 * @author Tiger
 */
public abstract class AbstractFishBatchHandler<REQ, RESP> {

	/**
	 * 获取请求类.
	 * 
	 * @return 请求类
	 */
	@SuppressWarnings("unchecked")
	public Class<REQ> getRequestClass() {
		Class<REQ> tClass = (Class<REQ>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	/**
	 * 获取响应类.
	 * 
	 * @return 响应类
	 */
	@SuppressWarnings("unchecked")
	public Class<RESP> getResponseClass() {
		Class<RESP> tClass = (Class<RESP>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[1];
		return tClass;
	}
	
	/**
	 * 处理函数.
	 * 
	 * @param request 请求
	 * @return response 响应 
	 * @throws BatchException 异常
	 */
	public abstract RESP handle(REQ request) throws BatchException;
}
