package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.List;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInfosRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInfosResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInfo;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取所有Job信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobInfosHandler extends AbstractFishBatchHandler<FishBatchGetJobInfosRequest, FishBatchGetJobInfosResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobInfosResponse handle(FishBatchGetJobInfosRequest request) {

		log.debug("FishBatchGetJobInfosRequest:{}", request);

		FishBatchGetJobInfosResponse response = request.createResponse();
		
		List<FishBatchJobInfo> jobInfos = this.fishBatchService.getJobInfos();
		
		response.setJobInfos(jobInfos);
		
		return response;
	}

}
