package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstanceRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstanceResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInstance;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个Job实例.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobInstanceHandler extends AbstractFishBatchHandler<FishBatchGetJobInstanceRequest, FishBatchGetJobInstanceResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobInstanceResponse handle(FishBatchGetJobInstanceRequest request) {
		
		log.debug("FishBatchGetJobInstanceRequest:{}", request);
		
		FishBatchGetJobInstanceResponse response = request.createResponse();
		
		FishBatchJobInstance jobInstance = this.fishBatchService.getJobInstance(request.getInstanceId());
		
		response.setJobInstance(jobInstance);
		
		return response;
	}

}
