package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.Set;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetRunningJobExecutionsRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetRunningJobExecutionsResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 查找某个job正在执行的信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetRunningJobExecutionsHandler extends AbstractFishBatchHandler<FishBatchGetRunningJobExecutionsRequest, FishBatchGetRunningJobExecutionsResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetRunningJobExecutionsResponse handle(FishBatchGetRunningJobExecutionsRequest request) {
		
		log.debug("FishBatchFindRunJobExecutionsRequest:{}", request);
		
		FishBatchGetRunningJobExecutionsResponse response = request.createResponse();
		
		Set<FishBatchJobExecution> jobExecutions = this.fishBatchService.findRunningJobExecutions(request.getJobName());
		
		response.setJobExecutions(jobExecutions);
		
		return response;
	}

}
