package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartByJobNameRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartByJobNameResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 根据批量任务名重启最近一次失败批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchRestartByJobNameHandler extends AbstractFishBatchHandler<FishBatchRestartByJobNameRequest, FishBatchRestartByJobNameResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchRestartByJobNameResponse handle(FishBatchRestartByJobNameRequest request) {
		
		log.debug("Fish Batch Restart By JobName, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		//组装响应
		FishBatchRestartByJobNameResponse response = request.createResponse();
		
		Long jobExecutionId = this.fishBatchService.restartByJobName(request.getOperator(), request.getJobName());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
