package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 重启批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchRestartHandler extends AbstractFishBatchHandler<FishBatchRestartRequest, FishBatchRestartResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchRestartResponse handle(FishBatchRestartRequest request) {
		
		log.debug("Fish Batch Restart, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//批量请求参数校验
		if (request.getJobExecutionId() == null) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//组装响应
		FishBatchRestartResponse response = request.createResponse();
		
		Long jobExecutionId = this.fishBatchService.restart(request.getOperator(), request.getJobExecutionId());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
