package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 启动批量.
 * <p>批量参数外传,不会执行批量的JobIncrementer</p>
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchStartHandler extends AbstractFishBatchHandler<FishBatchStartRequest, FishBatchStartResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchStartResponse handle(FishBatchStartRequest request) {
		
		log.debug("Fish Batch Start, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		
		//组装响应
		FishBatchStartResponse response = request.createResponse();
		
		//启动批量
		Long jobExecutionId = this.fishBatchService.start(request.getOperator(), request.getJobName(), 
				request.getParameters(), request.getCheckLastJob());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
