/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.explore;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchExploreRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchExploreResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchActivator;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.exception.FishSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class FishBatchExplorerActivator
extends AbstractFishBatchActivator<FishBatchExploreRequest<FishBatchExploreResponse>, FishBatchExploreResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchExplorerActivator.class);

    @ServiceActivator(inputChannel="fishBatchExploreChannel")
    public FishBatchExploreResponse activate(FishBatchExploreRequest<FishBatchExploreResponse> request) {
        log.debug("activate fishBatchExploreRequest:{}", request);
        FishBatchExploreResponse response = null;
        try {
            response = (FishBatchExploreResponse)this.doActivate(request);
        }
        catch (FishSkeletonBatchBadRequestException e) {
            response = (FishBatchExploreResponse)request.createResponse();
            response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
            response.setRespDesc(e.getLocalizedMessage());
        }
        log.debug("activate FishBatchExploreResponse:{}", (Object)response);
        return response;
    }

    @Override
    public FishBatchExploreResponse responseWithException(FishBatchExploreRequest<FishBatchExploreResponse> request, Exception exception) {
        FishBatchExploreResponse response = (FishBatchExploreResponse)request.createResponse();
        if (exception instanceof FishBatchException) {
            response.setRespCode(((FishBatchException)exception).getRespCode());
            response.setRespDesc(((FishBatchException)exception).getRespDesc());
        } else {
            response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
            response.setRespDesc(exception.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public Object insertJournal(FishBatchExploreRequest<FishBatchExploreResponse> request) {
        return null;
    }

    @Override
    public void updateJournal(Object journal, AbstractFishBatchHandler<FishBatchExploreRequest<FishBatchExploreResponse>, FishBatchExploreResponse> handler, FishBatchExploreResponse response) {
    }
}

