/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.ArrayList;
import java.util.List;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsByJobNameRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsByJobNameResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FishBatchGetJobExecutionsByJobNameHandler
extends AbstractFishBatchHandler<FishBatchGetJobExecutionsByJobNameRequest, FishBatchGetJobExecutionsByJobNameResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchGetJobExecutionsByJobNameHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchGetJobExecutionsByJobNameResponse handle(FishBatchGetJobExecutionsByJobNameRequest request) {
        log.debug("FishBatchGetJobExecutionsByJobNameRequest:{}", (Object)request);
        FishBatchGetJobExecutionsByJobNameResponse response = (FishBatchGetJobExecutionsByJobNameResponse)request.createResponse();
        Integer jobTotalSize = this.fishBatchService.getJobInstanceCount(request.getJobName());
        List<Object> jobExecutions = new ArrayList();
        if (jobTotalSize > 0) {
            jobExecutions = this.fishBatchService.getJobExecutionsByJobName(request.getJobName(), request.getJobStart(), request.getJobCount());
        }
        response.setJobTotalSize(jobTotalSize);
        response.setJobExecutions(jobExecutions);
        return response;
    }
}

