/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.List;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstancesRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstancesResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInstance;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FishBatchGetJobInstancesHandler
extends AbstractFishBatchHandler<FishBatchGetJobInstancesRequest, FishBatchGetJobInstancesResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchGetJobInstancesHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchGetJobInstancesResponse handle(FishBatchGetJobInstancesRequest request) {
        log.debug("FishBatchGetJobInstancesRequest:{}", (Object)request);
        FishBatchGetJobInstancesResponse response = (FishBatchGetJobInstancesResponse)request.createResponse();
        Integer jobTotalSize = this.fishBatchService.getJobInstanceCount(request.getJobName());
        response.setJobInstancesSize(jobTotalSize);
        List<FishBatchJobInstance> jobInstances = this.fishBatchService.getJobInstances(request.getJobName(), request.getStart(), request.getCount());
        response.setJobInstances(jobInstances);
        return response;
    }
}

