/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchOperateRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchOperateResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchActivator;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.exception.FishSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class FishBatchOperatorActivator
extends AbstractFishBatchActivator<FishBatchOperateRequest<FishBatchOperateResponse>, FishBatchOperateResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchOperatorActivator.class);

    @ServiceActivator(inputChannel="fishBatchOperateChannel")
    public FishBatchOperateResponse activate(FishBatchOperateRequest<FishBatchOperateResponse> request) {
        log.debug("activate FishBatchOperateRequest:{}", request);
        FishBatchOperateResponse response = null;
        try {
            response = (FishBatchOperateResponse)this.doActivate(request);
        }
        catch (FishSkeletonBatchBadRequestException e) {
            response = (FishBatchOperateResponse)request.createResponse();
            response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
            response.setRespDesc(e.getLocalizedMessage());
        }
        log.debug("activate FishBatchOperateResponse:{}", (Object)response);
        return response;
    }

    @Override
    public FishBatchOperateResponse responseWithException(FishBatchOperateRequest<FishBatchOperateResponse> request, Exception exception) {
        FishBatchOperateResponse response = (FishBatchOperateResponse)request.createResponse();
        if (exception instanceof FishBatchException) {
            response.setRespCode(((FishBatchException)exception).getRespCode());
            response.setRespDesc(((FishBatchException)exception).getRespDesc());
        } else {
            response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
            response.setRespDesc(exception.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public Object insertJournal(FishBatchOperateRequest<FishBatchOperateResponse> request) {
        return null;
    }

    @Override
    public void updateJournal(Object journal, AbstractFishBatchHandler<FishBatchOperateRequest<FishBatchOperateResponse>, FishBatchOperateResponse> handler, FishBatchOperateResponse response) {
    }
}

