/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchAbandonRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchAbandonResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FishBatchAbandonHandler
extends AbstractFishBatchHandler<FishBatchAbandonRequest, FishBatchAbandonResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchAbandonHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchAbandonResponse handle(FishBatchAbandonRequest request) {
        log.debug("Fish Batch Abandon, operator:{}, jobExecutionId:{}", (Object)request.getOperator(), (Object)request.getJobExecutionId());
        if (request.getJobExecutionId() == null) {
            throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FishBatchAbandonResponse response = (FishBatchAbandonResponse)request.createResponse();
        FishBatchJobExecution jobExecution = this.fishBatchService.abandon(request.getOperator(), request.getJobExecutionId());
        response.setJobExecution(jobExecution);
        return response;
    }
}

