/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartByJobNameRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartByJobNameResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FishBatchRestartByJobNameHandler
extends AbstractFishBatchHandler<FishBatchRestartByJobNameRequest, FishBatchRestartByJobNameResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchRestartByJobNameHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchRestartByJobNameResponse handle(FishBatchRestartByJobNameRequest request) {
        log.debug("Fish Batch Restart By JobName, operator:{}, jobName:{}", (Object)request.getOperator(), (Object)request.getJobName());
        if (!StringUtils.hasLength((String)request.getJobName())) {
            throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FishBatchRestartByJobNameResponse response = (FishBatchRestartByJobNameResponse)request.createResponse();
        Long jobExecutionId = this.fishBatchService.restartByJobName(request.getOperator(), request.getJobName());
        response.setJobExecutionId(jobExecutionId);
        return response;
    }
}

