package org.krproject.ocean.skeletons.fish.batch.endpoint.explore;

import org.krproject.ocean.skeletons.fish.batch.api.constants.FishSkeletonBatchApiIntegrationConstants;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchExploreRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchExploreResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchActivator;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.exception.FishSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

import lombok.extern.slf4j.Slf4j;

/**
 * fish批量查询服务端点.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@MessageEndpoint
public class FishBatchExplorerActivator extends AbstractFishBatchActivator<FishBatchExploreRequest<FishBatchExploreResponse>, FishBatchExploreResponse> {
	
	@ServiceActivator(inputChannel = FishSkeletonBatchApiIntegrationConstants.EXPLORE_CHANNEL_NAME)
	public FishBatchExploreResponse activate(FishBatchExploreRequest<FishBatchExploreResponse> request) {
		log.debug("activate fishBatchExploreRequest:{}", request);
		// 调用批量处理
		FishBatchExploreResponse response = null;
		try {
			response = doActivate(request);
		} catch (FishSkeletonBatchBadRequestException e) {
			response = request.createResponse();
			response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
			response.setRespDesc(e.getLocalizedMessage());
		}
		log.debug("activate FishBatchExploreResponse:{}", response);
		return response;
	}

	@Override
	public FishBatchExploreResponse responseWithException(FishBatchExploreRequest<FishBatchExploreResponse> request,
			Exception exception) {
		FishBatchExploreResponse response = request.createResponse();
		if (exception instanceof FishBatchException) {
			response.setRespCode(((FishBatchException) exception).getRespCode());
			response.setRespDesc(((FishBatchException) exception).getRespDesc());
		} else {
			response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
			response.setRespDesc(exception.getLocalizedMessage());
		}
		return response;
	}
	
	@Override
	public Object insertJournal(FishBatchExploreRequest<FishBatchExploreResponse> request) {
		return null;
	}

	@Override
	public void updateJournal(Object journal,
			AbstractFishBatchHandler<FishBatchExploreRequest<FishBatchExploreResponse>, FishBatchExploreResponse> handler,
			FishBatchExploreResponse response) {
		
	}

}
