package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取Job执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobExecutionHandler extends AbstractFishBatchHandler<FishBatchGetJobExecutionRequest, FishBatchGetJobExecutionResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobExecutionResponse handle(FishBatchGetJobExecutionRequest request) {
		
		log.debug("FishBatchGetJobExecutionRequest:{}", request);
		
		FishBatchGetJobExecutionResponse response = request.createResponse();
		
		FishBatchJobExecution jobExecution = this.fishBatchService.getJobExecution(request.getExecutionId());
		
		response.setJobExecution(jobExecution);
		
		return response;
	}

}
