package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.ArrayList;
import java.util.List;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsByJobNameRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsByJobNameResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 根据JobName获取执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobExecutionsByJobNameHandler extends AbstractFishBatchHandler<FishBatchGetJobExecutionsByJobNameRequest, FishBatchGetJobExecutionsByJobNameResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobExecutionsByJobNameResponse handle(FishBatchGetJobExecutionsByJobNameRequest request) {
		
		log.debug("FishBatchGetJobExecutionsByJobNameRequest:{}", request);
		
		FishBatchGetJobExecutionsByJobNameResponse response = request.createResponse();
		
		// 获取实例总个数
		Integer jobTotalSize = this.fishBatchService.getJobInstanceCount(request.getJobName());
		
		// 根据Job实例获取执行信息
		List<FishBatchJobExecution> jobExecutions = new ArrayList<>();
		if (jobTotalSize > 0) {
			jobExecutions = this.fishBatchService.getJobExecutionsByJobName(request.getJobName(), 
					request.getJobStart(), request.getJobCount());
		}
		
		response.setJobTotalSize(jobTotalSize);
		response.setJobExecutions(jobExecutions);
		
		return response;
	}

}
