package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.List;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobExecutionsResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个Job实例的所有执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobExecutionsHandler extends AbstractFishBatchHandler<FishBatchGetJobExecutionsRequest, FishBatchGetJobExecutionsResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobExecutionsResponse handle(FishBatchGetJobExecutionsRequest request) {
		
		log.debug("FishBatchGetJobExecutionsRequest:{}", request);
		
		FishBatchGetJobExecutionsResponse response = request.createResponse();
		
		List<FishBatchJobExecution> jobExecutions = this.fishBatchService.getJobExecutions(request.getInstanceId());
		
		response.setJobExecutions(jobExecutions);
		
		return response;
	}

}
