package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import java.util.List;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstancesRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetJobInstancesResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInstance;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个job的所有实例.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetJobInstancesHandler extends AbstractFishBatchHandler<FishBatchGetJobInstancesRequest, FishBatchGetJobInstancesResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetJobInstancesResponse handle(FishBatchGetJobInstancesRequest request) {
		
		log.debug("FishBatchGetJobInstancesRequest:{}", request);
		
		FishBatchGetJobInstancesResponse response = request.createResponse();
		
		// 获取实例总个数
		Integer jobTotalSize = this.fishBatchService.getJobInstanceCount(request.getJobName());
		response.setJobInstancesSize(jobTotalSize);
		
		List<FishBatchJobInstance> jobInstances = this.fishBatchService.getJobInstances(request.getJobName(), 
				request.getStart(), request.getCount());
		
		response.setJobInstances(jobInstances);
		
		return response;
	}

}
