package org.krproject.ocean.skeletons.fish.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetStepExecutionRequest;
import org.krproject.ocean.skeletons.fish.batch.api.explore.FishBatchGetStepExecutionResponse;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchStepExecution;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取Step执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchGetStepExecutionHandler extends AbstractFishBatchHandler<FishBatchGetStepExecutionRequest, FishBatchGetStepExecutionResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchGetStepExecutionResponse handle(FishBatchGetStepExecutionRequest request) {
		
		log.debug("FishBatchGetStepExecutionRequest:{}", request);
		
		FishBatchGetStepExecutionResponse response = request.createResponse();
		
		FishBatchStepExecution stepExecution = this.fishBatchService.getStepExecution(request.getJobExecutionId(), request.getStepExecutionId());
		
		response.setStepExecution(stepExecution);
		
		return response;
	}

}
