package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchAbandonRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchAbandonResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 废弃批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchAbandonHandler extends AbstractFishBatchHandler<FishBatchAbandonRequest, FishBatchAbandonResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchAbandonResponse handle(FishBatchAbandonRequest request) {
		
		log.debug("Fish Batch Abandon, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//请求校验
		if (request.getJobExecutionId() == null) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//组装响应
		FishBatchAbandonResponse response = request.createResponse();
		
		//启动批量
		FishBatchJobExecution jobExecution = this.fishBatchService.abandon(request.getOperator(), request.getJobExecutionId());
		
		response.setJobExecution(jobExecution);
		
		return response;
	}

}
