package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartNextInstanceRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartNextInstanceResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 启动下一个批量实例.
 * <p>批量参数由JobIncrementer生成,建议使用该方式启动批量,保证批量参数执行可控</p>
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchStartNextInstanceHandler extends AbstractFishBatchHandler<FishBatchStartNextInstanceRequest, FishBatchStartNextInstanceResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchStartNextInstanceResponse handle(FishBatchStartNextInstanceRequest request) {
		
		log.debug("Fish Batch Start NextInstance, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		
		//组装响应
		FishBatchStartNextInstanceResponse response = request.createResponse();
		
		//启动批量
		Long jobExecutionId = this.fishBatchService.startNextInstance(request.getOperator(), request.getJobName(), 
				request.getCheckLastJob());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
