package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStopRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStopResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.krproject.ocean.vitamins.batch.exception.BatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 停止批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class FishBatchStopHandler extends AbstractFishBatchHandler<FishBatchStopRequest, FishBatchStopResponse> {
	
	@Autowired
	private FishBatchService fishBatchService;

	@Override
	public FishBatchStopResponse handle(FishBatchStopRequest request) throws BatchException {
		
		log.debug("Fish Batch Stop, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//请求校验
		if (request.getJobExecutionId() == null) {
			throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//启动批量
		FishBatchStopResponse response = request.createResponse();
		
		boolean status = this.fishBatchService.stop(request.getOperator(), request.getJobExecutionId());
	
		//组装响应
		response.setStopped(status);
		
		return response;
	}

}
