package org.krproject.ocean.skeletons.fish.batch.service;

import java.util.List;
import java.util.Set;

import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInfo;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInstance;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchStepExecution;

/**
 * fish批量服务.
 * @author zhongyang
 *
 */
public interface FishBatchService {
	
	//根据JobName获取批量作业信息
	FishBatchJobInfo getJobInfoByJobName(String jobName);
	
	//获取所有批量作业
	List<FishBatchJobInfo> getJobInfos();
	
	//启动批量
	Long start(String operateUser, String jobName, String parameters, Boolean checkLastJob);
	
	//重启批量
	Long restart(String operateUser, long executionId);
	
	//根据批量名重启批量
	Long restartByJobName(String operateUser, String jobName);
	
	//停止批量
	boolean stop(String operateUser, long executionId);
	
	//废弃批量
	FishBatchJobExecution abandon(String operateUser, long jobExecutionId);
	
	//启动下一个批量实例
	Long startNextInstance(String operateUser, String jobName, Boolean checkLastJob);
	
	//根据Job执行ID将非成功状态置为失败，暂只支持本地
	void updateJobFailedByJobExecutionId(String operateUser, Long jobExecutionId);
	
	//根据批量名获取所有批量实例
	List<FishBatchJobInstance> getJobInstances(String jobName, int start, int count);
	
	//根据Job执行ID获取执行信息
	FishBatchJobExecution getJobExecution(Long executionId);
	
	//获取Step执行信息
	FishBatchStepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId);
	
	//根据实例ID获取实例信息
	FishBatchJobInstance getJobInstance(Long instanceId);
	
	//根据实例ID获取执行信息
	List<FishBatchJobExecution> getJobExecutions(Long instanceId);
	
	//根据JobName获取实例个数
	int getJobInstanceCount(String jobName);
	
	//根据JobName获取执行信息
	List<FishBatchJobExecution> getJobExecutionsByJobName(String jobName, int start, int count);
	
	//根据批量名获取正在执行的执行信息
	Set<FishBatchJobExecution> findRunningJobExecutions(String jobName);
	
}
