package org.krproject.ocean.skeletons.fish.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobExecution;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInfo;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobInstance;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobParameter;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchJobParameters;
import org.krproject.ocean.skeletons.fish.batch.api.model.FishBatchStepExecution;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.service.BatchService;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobExecution;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInfo;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInstance;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobParameter;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobParameters;
import org.krproject.ocean.vitamins.batch.service.model.BatchStepExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * fish批量服务实现.
 * @author zhongyang
 *
 */
@Service
public class FishBatchServiceImpl implements FishBatchService {
	
	@Autowired
	private BatchService batchService;

	@Override
	public FishBatchJobInfo getJobInfoByJobName(String jobName) {
		return batchJobInfoConvert(this.batchService.getJobInfoByJobName(jobName));
	}

	@Override
	public List<FishBatchJobInfo> getJobInfos() {
		List<FishBatchJobInfo> fishBatchJobInfos = new ArrayList<>();
		List<BatchJobInfo> batchJobInfos = this.batchService.getJobInfos();
		if (batchJobInfos != null && !batchJobInfos.isEmpty()) {
			for (BatchJobInfo batchJobInfo : batchJobInfos) {
				fishBatchJobInfos.add(batchJobInfoConvert(batchJobInfo));
			}
		}
		return fishBatchJobInfos;
	}

	@Override
	public Long start(String operateUser, String jobName, String parameters, Boolean checkLastJob) {
		return this.batchService.start(operateUser, jobName, parameters, checkLastJob);
	}

	@Override
	public Long restart(String operateUser, long executionId) {
		return this.batchService.restart(operateUser, executionId);
	}

	@Override
	public Long restartByJobName(String operateUser, String jobName) {
		return this.batchService.restartByJobName(operateUser, jobName);
	}

	@Override
	public boolean stop(String operateUser, long executionId) {
		return this.batchService.stop(operateUser, executionId);
	}

	@Override
	public FishBatchJobExecution abandon(String operateUser, long jobExecutionId) {
		return jobExecutionConvert(this.batchService.abandon(operateUser, jobExecutionId));
	}

	@Override
	public Long startNextInstance(String operateUser, String jobName, Boolean checkLastJob) {
		return this.batchService.startNextInstance(operateUser, jobName, checkLastJob);
	}

	@Override
	public void updateJobFailedByJobExecutionId(String operateUser, Long jobExecutionId) {
		this.batchService.updateJobFailedByJobExecutionId(operateUser, jobExecutionId);
	}

	@Override
	public List<FishBatchJobInstance> getJobInstances(String jobName, int start, int count) {
		return jobInstancesConvert(this.batchService.getJobInstances(jobName, start, count));
	}

	@Override
	public FishBatchJobExecution getJobExecution(Long executionId) {
		return jobExecutionConvert(this.batchService.getJobExecution(executionId));
	}

	@Override
	public FishBatchStepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) {
		return stepExecutionConvert(this.batchService.getStepExecution(jobExecutionId, stepExecutionId));
	}

	@Override
	public FishBatchJobInstance getJobInstance(Long instanceId) {
		return jobInstanceConvert(this.batchService.getJobInstance(instanceId));
	}

	@Override
	public List<FishBatchJobExecution> getJobExecutions(Long instanceId) {
		return jobExecutionsConvert(this.batchService.getJobExecutions(instanceId));
	}

	@Override
	public int getJobInstanceCount(String jobName) {
		return this.batchService.getJobInstanceCount(jobName);
	}

	@Override
	public List<FishBatchJobExecution> getJobExecutionsByJobName(String jobName, int start, int count) {
		return jobExecutionsConvert(this.batchService.getJobExecutionsByJobName(jobName, start, count));
	}

	@Override
	public Set<FishBatchJobExecution> findRunningJobExecutions(String jobName) {
		return jobExecutionsConvert(this.batchService.findRunningJobExecutions(jobName));
	}
	
	private FishBatchJobInfo batchJobInfoConvert(BatchJobInfo batchJobInfo) {
		if (batchJobInfo != null) {
			FishBatchJobInfo fishBatchJobInfo = new FishBatchJobInfo();
			fishBatchJobInfo.setJobName(batchJobInfo.getJobName());
			fishBatchJobInfo.setJobDescrition(batchJobInfo.getJobDescrition());
			return fishBatchJobInfo;
		}
		return null;
	}
	
	private List<FishBatchJobExecution> jobExecutionsConvert(List<BatchJobExecution> jobExecutions) {
		List<FishBatchJobExecution> jobExecutionsModel = new ArrayList<>();
		if (jobExecutions != null && jobExecutions.size() > 0) {
			Iterator<BatchJobExecution> jobExecutionIte = jobExecutions.iterator();
			while (jobExecutionIte.hasNext()) {
				BatchJobExecution jobExecution = jobExecutionIte.next();
				jobExecutionsModel.add(jobExecutionConvert(jobExecution));
			}
		}
		return jobExecutionsModel;
	}
	
	private Set<FishBatchJobExecution> jobExecutionsConvert(Set<BatchJobExecution> jobExecutions) {
		Set<FishBatchJobExecution> jobExecutionsModel = new CopyOnWriteArraySet<>();
		if (jobExecutions != null && jobExecutions.size() > 0) {
			Iterator<BatchJobExecution> jobExecutionIte = jobExecutions.iterator();
			while (jobExecutionIte.hasNext()) {
				BatchJobExecution jobExecution = jobExecutionIte.next();
				jobExecutionsModel.add(jobExecutionConvert(jobExecution));
			}
		}
		return jobExecutionsModel;
	}
	
	private FishBatchJobExecution jobExecutionConvert(BatchJobExecution jobExecution) {
		FishBatchJobExecution jobExecutionModel = null;
		if (jobExecution != null) {
			jobExecutionModel = new FishBatchJobExecution();
			jobExecutionModel.setId(jobExecution.getId());
			jobExecutionModel.setJobParameters(jobParametersConvert(jobExecution.getJobParameters()));
			jobExecutionModel.setJobInstance(jobInstanceConvert(jobExecution.getJobInstance()));
			jobExecutionModel.setStepExecutions(stepExecutionsConvert(jobExecution.getStepExecutions()));
			if (jobExecution.getStatus() != null) {
				jobExecutionModel.setStatus(jobExecution.getStatus());
			}
			jobExecutionModel.setStartTime(jobExecution.getStartTime());
			jobExecutionModel.setCreateTime(jobExecution.getCreateTime());
			jobExecutionModel.setEndTime(jobExecution.getEndTime());
			jobExecutionModel.setLastUpdated(jobExecution.getLastUpdated());
			if (jobExecution.getExitStatus() != null) {
				jobExecutionModel.setExitStatus(jobExecution.getExitStatus());
			}
			jobExecutionModel.setJobConfigurationName(jobExecution.getJobConfigurationName());
		}
		return jobExecutionModel;
	}
	
	private List<FishBatchJobInstance> jobInstancesConvert(List<BatchJobInstance> jobInstances) {
		List<FishBatchJobInstance> jobInstancesModel = new ArrayList<>();
		if (jobInstances != null && jobInstances.size() > 0) {
			for (BatchJobInstance jobInstance : jobInstances) {
				jobInstancesModel.add(jobInstanceConvert(jobInstance));
			}
		}
		return jobInstancesModel;
	}
	
	private FishBatchJobInstance jobInstanceConvert(BatchJobInstance jobInstance) {
		FishBatchJobInstance jobInstanceModel = null;
		if (jobInstance != null) {
			jobInstanceModel = new FishBatchJobInstance();
			jobInstanceModel.setId(jobInstance.getId());
			jobInstanceModel.setInstanceId(jobInstance.getInstanceId());
			jobInstanceModel.setJobName(jobInstance.getJobName());
		}
		return jobInstanceModel;
	}
	
	private FishBatchJobParameters jobParametersConvert(BatchJobParameters jobParameters) {
		FishBatchJobParameters jobParametersModel = null;
		if (jobParameters != null) {
			jobParametersModel = new FishBatchJobParameters();
			Map<String, BatchJobParameter> paramMap = jobParameters.getParameters();
			if (!paramMap.isEmpty()) {
				Map<String, FishBatchJobParameter> paramMapModel = new HashMap<>();
				for (Entry<String, BatchJobParameter> enSet : paramMap.entrySet()) {
					paramMapModel.put(enSet.getKey(), jobParameterConvert(enSet.getValue()));
				}
				jobParametersModel.setParameters(paramMapModel);
			}
		}
		return jobParametersModel;
	}
	
	private FishBatchJobParameter jobParameterConvert(BatchJobParameter jobParameter) {
		FishBatchJobParameter jobParameterModel = null;
		if (jobParameter != null) {
			jobParameterModel = new FishBatchJobParameter();
			jobParameterModel.setParameter(jobParameter.getParameter());
			jobParameterModel.setParameterType(jobParameter.getParameterType());
		}
		return jobParameterModel;
	}
	
	private Collection<FishBatchStepExecution> stepExecutionsConvert(Collection<BatchStepExecution> stepExecutions) {
		Collection<FishBatchStepExecution> stepExecutionsModel = new CopyOnWriteArraySet<FishBatchStepExecution>();
		if (stepExecutions != null && stepExecutions.size() > 0) {
			Iterator<BatchStepExecution> stepExecutionIte = stepExecutions.iterator();
			while (stepExecutionIte.hasNext()) {
				BatchStepExecution stepExecution = stepExecutionIte.next();
				stepExecutionsModel.add(stepExecutionConvert(stepExecution));
			}
		}
		return stepExecutionsModel;
	}
	
	private FishBatchStepExecution stepExecutionConvert(BatchStepExecution stepExecution) {
		FishBatchStepExecution stepExecutionModel = null;
		if (stepExecution != null) {
			stepExecutionModel = new FishBatchStepExecution();
			stepExecutionModel.setId(stepExecution.getId());
			stepExecutionModel.setJobExecutionId(stepExecution.getJobExecutionId());
			stepExecutionModel.setStepName(stepExecution.getStepName());
			stepExecutionModel.setStatus(stepExecution.getStatus());
			stepExecutionModel.setReadCount(stepExecution.getReadCount());
			stepExecutionModel.setWriteCount(stepExecution.getWriteCount());
			stepExecutionModel.setCommitCount(stepExecution.getCommitCount());
			stepExecutionModel.setRollbackCount(stepExecution.getRollbackCount());
			stepExecutionModel.setReadSkipCount(stepExecution.getReadSkipCount());
			stepExecutionModel.setProcessSkipCount(stepExecution.getProcessSkipCount());
			stepExecutionModel.setWriteSkipCount(stepExecution.getWriteSkipCount());
			stepExecutionModel.setStartTime(stepExecution.getStartTime());
			stepExecutionModel.setEndTime(stepExecution.getLastUpdated());
			stepExecutionModel.setLastUpdated(stepExecution.getLastUpdated());
			stepExecutionModel.setExitStatus(stepExecution.getExitStatus());
			stepExecutionModel.setExitDescription(stepExecution.getExitDescription());
			stepExecutionModel.setFilterCount(stepExecution.getFilterCount());
		}
		return stepExecutionModel;
	}

}
