/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.krproject.ocean.skeletons.fish.batch.api.FishBatchRequest;
import org.krproject.ocean.skeletons.fish.batch.api.FishBatchResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishSkeletonBatchBadRequestException;
import org.krproject.ocean.skeletons.fish.batch.exception.FishSkeletonBatchException;
import org.krproject.ocean.vitamins.batch.exception.BatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

public abstract class AbstractFishBatchActivator<REQ extends FishBatchRequest<RESP>, RESP extends FishBatchResponse> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFishBatchActivator.class);
    @Autowired
    private Validator validator;
    @Autowired(required=false)
    private List<AbstractFishBatchHandler<?, ?>> handlers;
    private static boolean initialized = false;
    private static final Map<String, AbstractFishBatchHandler<?, ?>> HANDLER_MAP = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.handlers != null) {
                for (AbstractFishBatchHandler<?, ?> handler : this.handlers) {
                    AbstractFishBatchHandler<?, ?> handlerFound = HANDLER_MAP.get(handler.getRequestClass().getName());
                    if (handlerFound != null) {
                        log.error("handler {} and {} got same request name\uff1a{}", new Object[]{handlerFound, handler, handler.getRequestClass().getName()});
                        throw new RuntimeException("duplicate handler for request " + handler.getRequestClass().getName());
                    }
                    HANDLER_MAP.put(handler.getRequestClass().getName(), handler);
                    log.debug("Loaded Handler:{} for Request:{}", (Object)ClassUtils.getUserClass(handler).getName(), (Object)handler.getRequestClass().getName());
                }
            }
            initialized = true;
        }
    }

    public abstract RESP responseWithException(REQ var1, Exception var2);

    public abstract Object insertJournal(REQ var1);

    public abstract void updateJournal(Object var1, AbstractFishBatchHandler<REQ, RESP> var2, RESP var3);

    protected RESP doActivate(REQ request) throws BatchException {
        if (request == null) {
            log.error("request cant't be null");
            throw new FishSkeletonBatchBadRequestException("request cant't be null");
        }
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation cv = (ConstraintViolation)iterator.next();
            log.error("\u9519\u8bef\u63cf\u8ff0:{}, {}", (Object)cv.getPropertyPath(), (Object)cv.getMessage());
            throw new FishSkeletonBatchBadRequestException(cv.getMessage());
        }
        Object journal = this.insertJournal(request);
        FishBatchResponse response = null;
        AbstractFishBatchHandler<?, ?> handler = null;
        try {
            String requestClassName = ClassUtils.getUserClass(request).getName();
            handler = HANDLER_MAP.get(requestClassName);
            if (handler == null) {
                log.warn("Fail to get handler for request:{}", (Object)requestClassName);
                throw new FishSkeletonBatchException("No handler for " + requestClassName);
            }
            log.debug("Found Handler:{} for request:{}", handler.getClass(), request.getClass());
            response = (FishBatchResponse)handler.handle(request);
        }
        catch (Exception exception) {
            response = (FishBatchResponse)this.responseWithException(request, exception);
        }
        this.updateJournal(journal, handler, response);
        return (RESP)response;
    }
}

