/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchRestartResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FishBatchRestartHandler
extends AbstractFishBatchHandler<FishBatchRestartRequest, FishBatchRestartResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchRestartHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchRestartResponse handle(FishBatchRestartRequest request) {
        log.debug("Fish Batch Restart, operator:{}, jobExecutionId:{}", (Object)request.getOperator(), (Object)request.getJobExecutionId());
        if (request.getJobExecutionId() == null) {
            throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FishBatchRestartResponse response = (FishBatchRestartResponse)request.createResponse();
        Long jobExecutionId = this.fishBatchService.restart(request.getOperator(), request.getJobExecutionId());
        response.setJobExecutionId(jobExecutionId);
        return response;
    }
}

