/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartNextInstanceRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStartNextInstanceResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FishBatchStartNextInstanceHandler
extends AbstractFishBatchHandler<FishBatchStartNextInstanceRequest, FishBatchStartNextInstanceResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchStartNextInstanceHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchStartNextInstanceResponse handle(FishBatchStartNextInstanceRequest request) {
        log.debug("Fish Batch Start NextInstance, operator:{}, jobName:{}", (Object)request.getOperator(), (Object)request.getJobName());
        if (!StringUtils.hasLength((String)request.getJobName())) {
            throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FishBatchStartNextInstanceResponse response = (FishBatchStartNextInstanceResponse)request.createResponse();
        Long jobExecutionId = this.fishBatchService.startNextInstance(request.getOperator(), request.getJobName(), request.getCheckLastJob());
        response.setJobExecutionId(jobExecutionId);
        return response;
    }
}

