/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.fish.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStopRequest;
import org.krproject.ocean.skeletons.fish.batch.api.operate.FishBatchStopResponse;
import org.krproject.ocean.skeletons.fish.batch.endpoint.AbstractFishBatchHandler;
import org.krproject.ocean.skeletons.fish.batch.exception.FishBatchException;
import org.krproject.ocean.skeletons.fish.batch.service.FishBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.krproject.ocean.vitamins.batch.exception.BatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FishBatchStopHandler
extends AbstractFishBatchHandler<FishBatchStopRequest, FishBatchStopResponse> {
    private static final Logger log = LoggerFactory.getLogger(FishBatchStopHandler.class);
    @Autowired
    private FishBatchService fishBatchService;

    @Override
    public FishBatchStopResponse handle(FishBatchStopRequest request) throws BatchException {
        log.debug("Fish Batch Stop, operator:{}, jobExecutionId:{}", (Object)request.getOperator(), (Object)request.getJobExecutionId());
        if (request.getJobExecutionId() == null) {
            throw new FishBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FishBatchStopResponse response = (FishBatchStopResponse)request.createResponse();
        boolean status = this.fishBatchService.stop(request.getOperator(), request.getJobExecutionId());
        response.setStopped(Boolean.valueOf(status));
        return response;
    }
}

