package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore;

import org.krproject.ocean.skeletons.octopus.batch.api.constants.OctopusSkeletonBatchApiConstants;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchExploreRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchExploreResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchActivator;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.ClassUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 批量查询服务端点.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@MessageEndpoint
public class OctopusBatchExplorerActivator extends AbstractOctopusBatchActivator<OctopusBatchExploreRequest<OctopusBatchExploreResponse>, OctopusBatchExploreResponse> {
	
	@ServiceActivator(inputChannel = OctopusSkeletonBatchApiConstants.EXPLORE_CHANNEL_NAME)
	public OctopusBatchExploreResponse activate(OctopusBatchExploreRequest<OctopusBatchExploreResponse> request) {
		log.info("activate OctopusBatchExploreRequest, requestName:{}, systemId:{}",
				ClassUtils.getUserClass(request).getName(), request.getSystemId());
		log.debug("activate OctopusBatchExploreRequest:{}", request);
		OctopusBatchExploreResponse response = null;
		try {
			response = doActivate(request);
		} catch (OctopusSkeletonBatchBadRequestException e) {
			response = request.createResponse();
			response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
			response.setRespDesc(e.getLocalizedMessage());
		}
		log.debug("activate OctopusBatchExploreResponse:{}", response);
		log.info("activate OctopusBatchExploreResponse, responseName:{}, respCode:{}, respDesc:{}",
				ClassUtils.getUserClass(response).getName(), response.getRespCode(), response.getRespDesc());
		return response;
	}
	

	@Override
	public OctopusBatchExploreResponse responseWithException(
			OctopusBatchExploreRequest<OctopusBatchExploreResponse> request, Exception exception) {
		OctopusBatchExploreResponse response = request.createResponse();
		if (exception instanceof OctopusBatchException) {
			response.setRespCode(((OctopusBatchException) exception).getRespCode());
			response.setRespDesc(((OctopusBatchException) exception).getRespDesc());
		} else {
			response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
			response.setRespDesc(exception.getLocalizedMessage());
		}
		return response;
	}
	

	@Override
	public Object insertJournal(OctopusBatchExploreRequest<OctopusBatchExploreResponse> request) {
		return null;
	}
	

	@Override
	public void updateJournal(Object journal,
			AbstractOctopusBatchHandler<OctopusBatchExploreRequest<OctopusBatchExploreResponse>, OctopusBatchExploreResponse> handler,
			OctopusBatchExploreResponse response) {
		
	}

}
