package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInstancesRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInstancesResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstances;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个job的所有实例.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobInstancesHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobInstancesRequest, OctopusBatchGetJobInstancesResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobInstancesResponse handle(OctopusBatchGetJobInstancesRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchGetJobInstancesRequest:{}", request);
		
		OctopusBatchGetJobInstancesResponse response = request.createResponse();
		
		OctopusBatchJobInstances octopusBatchJobInstances = this.octopusBatchService.getJobInstances(request.getSystemId(), 
				request.getJobName(), request.getStart(), request.getCount());
		
		response.setJobInstancesSize(octopusBatchJobInstances.getJobInstancesSize());
		response.setJobInstances(octopusBatchJobInstances.getJobInstances());
		
		return response;
	}

}
