package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetStepExecutionRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetStepExecutionResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchStepExecution;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.exception.BatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取Step执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetStepExecutionHandler extends AbstractOctopusBatchHandler<OctopusBatchGetStepExecutionRequest, OctopusBatchGetStepExecutionResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetStepExecutionResponse handle(OctopusBatchGetStepExecutionRequest request) throws BatchException {
		
		log.debug("OctopusBatchGetStepExecutionRequest:{}", request);
		
		OctopusBatchGetStepExecutionResponse response = request.createResponse();
		
		OctopusBatchStepExecution stepExecution = this.octopusBatchService.getStepExecution(request.getSystemId(), request.getJobExecutionId(), request.getStepExecutionId());
		
		response.setStepExecution(stepExecution);
		
		return response;
	}

}
