/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.krproject.ocean.skeletons.octopus.batch.api.OctopusBatchRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.OctopusBatchResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.event.OctopusBatchCompletedEvent;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchBadRequestException;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchException;
import org.krproject.ocean.vitamins.batch.exception.BatchException;
import org.krproject.ocean.vitamins.service.config.ServiceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ClassUtils;

public abstract class AbstractOctopusBatchActivator<REQ extends OctopusBatchRequest<RESP>, RESP extends OctopusBatchResponse> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOctopusBatchActivator.class);
    @Autowired
    private Validator validator;
    @Autowired(required=false)
    private List<AbstractOctopusBatchHandler<?, ?>> handlers;
    @Autowired
    private ServiceProperties serviceProperties;
    @Resource
    private ApplicationContext applicationContext;
    private static boolean initialized = false;
    private static final Map<String, AbstractOctopusBatchHandler<?, ?>> HANDLER_MAP = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.handlers != null) {
                for (AbstractOctopusBatchHandler<?, ?> handler : this.handlers) {
                    AbstractOctopusBatchHandler<?, ?> handlerFound = HANDLER_MAP.get(handler.getRequestClass().getName());
                    if (handlerFound != null) {
                        log.error("handler {} and {} got same request name\uff1a{}", new Object[]{handlerFound, handler, handler.getRequestClass().getName()});
                        throw new RuntimeException("duplicate handler for request " + handler.getRequestClass().getName());
                    }
                    HANDLER_MAP.put(handler.getRequestClass().getName(), handler);
                    log.debug("Loaded Handler:{} for Request:{}", (Object)ClassUtils.getUserClass(handler).getName(), (Object)handler.getRequestClass().getName());
                }
            }
            initialized = true;
        }
    }

    public abstract RESP responseWithException(REQ var1, Exception var2);

    public abstract Object insertJournal(REQ var1);

    public abstract void updateJournal(Object var1, AbstractOctopusBatchHandler<REQ, RESP> var2, RESP var3);

    protected RESP doActivate(REQ request) throws BatchException {
        if (request == null) {
            log.error("request cant't be null");
            throw new OctopusSkeletonBatchBadRequestException("request cant't be null");
        }
        long requestTime = System.currentTimeMillis();
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation cv = (ConstraintViolation)iterator.next();
            log.error("\u9519\u8bef\u63cf\u8ff0:{}, {}", (Object)cv.getPropertyPath(), (Object)cv.getMessage());
            throw new OctopusSkeletonBatchBadRequestException(cv.getMessage());
        }
        Object journal = this.insertJournal(request);
        OctopusBatchResponse response = null;
        AbstractOctopusBatchHandler<?, ?> handler = null;
        try {
            String requestClassName = ClassUtils.getUserClass(request).getName();
            handler = HANDLER_MAP.get(requestClassName);
            if (handler == null) {
                log.warn("Fail to get handler for request:{}", (Object)requestClassName);
                throw new OctopusSkeletonBatchException("No handler for " + requestClassName);
            }
            log.debug("Found Handler:{} for request:{}", handler.getClass(), request.getClass());
            response = (OctopusBatchResponse)handler.handle(request);
        }
        catch (Exception exception) {
            response = (OctopusBatchResponse)this.responseWithException(request, exception);
        }
        this.updateJournal(journal, handler, response);
        long responseTime = System.currentTimeMillis();
        this.applicationContext.publishEvent((ApplicationEvent)new OctopusBatchCompletedEvent(this, this.serviceProperties.getInstanceId(), (OctopusBatchRequest<?>)request, new Date(requestTime), handler, response, new Date(responseTime)));
        return (RESP)response;
    }
}

