package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import java.util.List;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionsRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionsResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个Job实例的所有执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobExecutionsHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobExecutionsRequest, OctopusBatchGetJobExecutionsResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobExecutionsResponse handle(OctopusBatchGetJobExecutionsRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchGetJobExecutionsRequest:{}", request);
		
		OctopusBatchGetJobExecutionsResponse response = request.createResponse();
		
		List<OctopusBatchJobExecution> jobExecutions = this.octopusBatchService.getJobExecutions(request.getSystemId(), request.getInstanceId());
		
		response.setJobExecutions(jobExecutions);
		
		return response;
	}

}
