package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInstanceRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInstanceResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstance;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取某个Job实例.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobInstanceHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobInstanceRequest, OctopusBatchGetJobInstanceResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobInstanceResponse handle(OctopusBatchGetJobInstanceRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchGetJobInstanceRequest:{}", request);
		
		OctopusBatchGetJobInstanceResponse response = request.createResponse();
		
		OctopusBatchJobInstance jobInstance = this.octopusBatchService.getJobInstance(request.getSystemId(), request.getInstanceId());
		
		response.setJobInstance(jobInstance);
		
		return response;
	}

}
