package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import java.util.Set;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetRunningJobExecutionsRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetRunningJobExecutionsResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 查找某个job正在执行的信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetRunningJobExecutionsHandler extends AbstractOctopusBatchHandler<OctopusBatchGetRunningJobExecutionsRequest, OctopusBatchGetRunningJobExecutionsResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetRunningJobExecutionsResponse handle(OctopusBatchGetRunningJobExecutionsRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchFindRunJobExecutionsRequest:{}", request);
		
		OctopusBatchGetRunningJobExecutionsResponse response = request.createResponse();
		
		Set<OctopusBatchJobExecution> jobExecutions = this.octopusBatchService.findRunningJobExecutions(request.getSystemId(), request.getJobName());
		
		response.setJobExecutions(jobExecutions);
		
		return response;
	}

}
