package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStopRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStopResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 停止批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchStopHandler extends AbstractOctopusBatchHandler<OctopusBatchStopRequest, OctopusBatchStopResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchStopResponse handle(OctopusBatchStopRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Stop, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//请求校验
		if (request.getJobExecutionId() == null) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//启动批量
		OctopusBatchStopResponse response = request.createResponse();
		
		boolean status = this.octopusBatchService.stop(request.getOperator(), request.getSystemId(), request.getJobExecutionId());
	
		//组装响应
		response.setStopped(status);
		
		return response;
	}

}
