package org.krproject.ocean.skeletons.octopus.batch.systems;

import java.util.List;
import java.util.Set;

import org.krproject.ocean.skeletons.octopus.batch.api.constants.OctopusSkeletonBatchApiConstants;
import org.krproject.ocean.vitamins.batch.service.BatchService;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobExecution;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobExecutions;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInfo;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInstance;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInstances;
import org.krproject.ocean.vitamins.batch.service.model.BatchStepExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Octopus批量客户端.
 * @author zhongyang
 *
 */
@Component
public class OctopusBatchClient extends AbstractBatchClient {
	
	@Autowired
	private BatchService batchService;

	@Override
	public String getSystemId() {
		return OctopusSkeletonBatchApiConstants.SYSTEM_ID;
	}

	@Override
	public List<BatchJobInfo> getJobInfos() {
		return this.batchService.getJobInfos();
	}

	@Override
	public BatchJobInstances getJobInstances(String jobName, int start, int count) {
		BatchJobInstances batchJobInstances = new BatchJobInstances();
		batchJobInstances.setJobInstancesSize(this.batchService.getJobInstanceCount(jobName));
		batchJobInstances.setJobInstances(this.batchService.getJobInstances(jobName, start, count));
		return batchJobInstances;
	}

	@Override
	public BatchJobExecution getJobExecution(Long executionId) {
		return this.batchService.getJobExecution(executionId);
	}

	@Override
	public BatchStepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) {
		return this.batchService.getStepExecution(jobExecutionId, stepExecutionId);
	}

	@Override
	public BatchJobInstance getJobInstance(Long instanceId) {
		return this.batchService.getJobInstance(instanceId);
	}

	@Override
	public List<BatchJobExecution> getJobExecutions(Long instanceId) {
		return this.batchService.getJobExecutions(instanceId);
	}

	@Override
	public BatchJobExecutions getJobExecutionsByJobName(String jobName, int start, int count) {
		BatchJobExecutions batchJobExecutions = new BatchJobExecutions();
		batchJobExecutions.setJobTotalSize(this.batchService.getJobInstanceCount(jobName));
		batchJobExecutions.setJobExecutions(this.batchService.getJobExecutionsByJobName(jobName, start, count));
		return batchJobExecutions;
	}

	@Override
	public Set<BatchJobExecution> findRunningJobExecutions(String jobName) {
		return this.batchService.findRunningJobExecutions(jobName);
	}

	@Override
	public Long start(String operateUser, String jobName, String parameters, Boolean checkLastJob) {
		return this.batchService.start(operateUser, jobName, parameters, checkLastJob);
	}

	@Override
	public Long restart(String operateUser, long executionId) {
		return this.batchService.restart(operateUser, executionId);
	}

	@Override
	public Long restartByJobName(String operateUser, String jobName) {
		return this.batchService.restartByJobName(operateUser, jobName);
	}

	@Override
	public boolean stop(String operateUser, long executionId) {
		return this.batchService.stop(operateUser, executionId);
	}

	@Override
	public BatchJobExecution abandon(String operateUser, long jobExecutionId) {
		return this.batchService.abandon(operateUser, jobExecutionId);
	}

	@Override
	public Long startNextInstance(String operateUser, String jobName, Boolean checkLastJob) {
		return this.batchService.startNextInstance(operateUser, jobName, checkLastJob);
	}

}
