/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchExploreRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchExploreResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchActivator;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.ClassUtils;

@MessageEndpoint
public class OctopusBatchExplorerActivator
extends AbstractOctopusBatchActivator<OctopusBatchExploreRequest<OctopusBatchExploreResponse>, OctopusBatchExploreResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchExplorerActivator.class);

    @ServiceActivator(inputChannel="octopusSkeletonBatchExploreChannel")
    public OctopusBatchExploreResponse activate(OctopusBatchExploreRequest<OctopusBatchExploreResponse> request) {
        log.info("activate OctopusBatchExploreRequest, requestName:{}, systemId:{}", (Object)ClassUtils.getUserClass(request).getName(), (Object)request.getSystemId());
        log.debug("activate OctopusBatchExploreRequest:{}", request);
        OctopusBatchExploreResponse response = null;
        try {
            response = (OctopusBatchExploreResponse)this.doActivate(request);
        }
        catch (OctopusSkeletonBatchBadRequestException e) {
            response = (OctopusBatchExploreResponse)request.createResponse();
            response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
            response.setRespDesc(e.getLocalizedMessage());
        }
        log.debug("activate OctopusBatchExploreResponse:{}", (Object)response);
        log.info("activate OctopusBatchExploreResponse, responseName:{}, respCode:{}, respDesc:{}", new Object[]{ClassUtils.getUserClass((Object)response).getName(), response.getRespCode(), response.getRespDesc()});
        return response;
    }

    @Override
    public OctopusBatchExploreResponse responseWithException(OctopusBatchExploreRequest<OctopusBatchExploreResponse> request, Exception exception) {
        OctopusBatchExploreResponse response = (OctopusBatchExploreResponse)request.createResponse();
        if (exception instanceof OctopusBatchException) {
            response.setRespCode(((OctopusBatchException)exception).getRespCode());
            response.setRespDesc(((OctopusBatchException)exception).getRespDesc());
        } else {
            response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
            response.setRespDesc(exception.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public Object insertJournal(OctopusBatchExploreRequest<OctopusBatchExploreResponse> request) {
        return null;
    }

    @Override
    public void updateJournal(Object journal, AbstractOctopusBatchHandler<OctopusBatchExploreRequest<OctopusBatchExploreResponse>, OctopusBatchExploreResponse> handler, OctopusBatchExploreResponse response) {
    }
}

