package org.krproject.ocean.skeletons.octopus.online.api.internal;

import javax.validation.constraints.NotEmpty;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;


/**
 * 内部交易类-获取下游系统挡板场景请求.
 * 
 * @author Tiger
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@SuppressWarnings("serial")
public class OctopusListOutboundMockScenarioRequest extends OctopusInternalRequest<OctopusListOutboundMockScenarioResponse> {
	
	@NotEmpty(message = "下游系统编号不能为空")
	private String systemId;
	
}
