package org.krproject.ocean.skeletons.octopus.online.outbound;

import java.lang.reflect.ParameterizedType;

/**
 * 下游系统处理器抽象类.
 * 
 * @param <REQ> 请求泛型
 * @param <RESP> 响应泛型
 * @author Tiger
 */
public abstract class AbstractProcessor<REQ, RESP> {

	/**
	 * 获取请求处理名，用于对请求-处理器的匹配处理.
	 * 
	 * 默认为请求类名，挡板场景下应通过重写本方法实现挡板处理
	 * 
	 * @return 请求名
	 */
	@SuppressWarnings("unchecked")
	public String getRequestName() {
		Class<REQ> tClass = (Class<REQ>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass.getName();
	}

	/**
	 * 获取请求类.
	 * 
	 * @return 请求类
	 */
	@SuppressWarnings("unchecked")
	public Class<REQ> getRequestClass() {
		Class<REQ> tClass = (Class<REQ>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	/**
	 * 获取响应类.
	 * 
	 * @return 响应类
	 */
	@SuppressWarnings("unchecked")
	public Class<RESP> getResponseClass() {
		Class<RESP> tClass = (Class<RESP>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[1];
		return tClass;
	}
	
	/**
	 * 下游系统交易处理.
	 * 
	 * @param request 请求
	 * @return response 响应
	 * @throws Exception 异常
	 */
	public abstract RESP process(REQ request) throws Exception;
	
}
