package org.krproject.ocean.skeletons.octopus.online.transaction;

/**
 * 冲正抽象类.
 * 
 * @author Tiger
 */
public abstract class AbstractReverser {

	/**
	 * 冲正次数.
	 * @return 冲正次数.
	 */
	public abstract Integer getReverseTimes();
	
	/**
	 * 冲正间隔（毫秒）.
	 * @return 冲正间隔（毫秒）.
	 */
	public abstract Long getReverseInterval();

	/**
	 * 获取对应处理器名.
	 * 
	 * @return 对应处理器名
	 */
	public abstract String getProcessorName();
	
	/**
	 * 对指定下游系统交易进行冲正.
	 * 
	 * @param outboundId 下游系统交易编号
	 * 
	 * @return 原交易冲正是否成功
	 */
	public abstract Boolean reverse(String outboundId);
}
