package org.krproject.ocean.skeletons.octopus.online.transaction.service;

import java.util.List;

import org.krproject.ocean.skeletons.octopus.online.transaction.model.OnlineOutboundModel;


/**
 * Octopus联机事务处理接口.
 * 
 * @author Tiger
 */
public interface OctopusOnlineTransactionService {

	/**
	 * 对上游渠道交易进行异步质询.
	 * @param inboundId 上游渠道交易编号
	 */
	void inquire(String inboundId);
	
	/**
	 * 对上游渠道交易进行异步冲正.
	 * @param inboundId 上游渠道交易编号
	 */
	void reverse(String inboundId);
	
	/**
	 * 对上游渠道交易进行异步重做.
	 * @param inboundId 上游渠道交易编号
	 */
	void replay(String inboundId);
	
	/**
	 * 获取待质询的下游系统交易列表（按交易发生顺序）.
	 * @param inboundId 上游渠道交易编号
	 * @return 待质询的下游系统交易列表
	 */
	List<OnlineOutboundModel> listOutboundForInquire(String inboundId);
	
	/**
	 * 获取待冲正的下游系统交易列表（按交易发生逆序）.
	 * @param inboundId 上游渠道交易编号
	 * @return 待冲正的下游系统交易列表
	 */
	List<OnlineOutboundModel> listOutboundForReverse(String inboundId);
}
