/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.inbound;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineRequest;
import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineResponse;
import org.krproject.ocean.skeletons.octopus.online.context.OctopusOnlineContextHolder;
import org.krproject.ocean.skeletons.octopus.online.event.HandleCompletedEvent;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusBadRequestException;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusDuplicatedInboundException;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusNotPermittedException;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusSkeletonOnlineException;
import org.krproject.ocean.skeletons.octopus.online.inbound.AbstractHandler;
import org.krproject.ocean.skeletons.octopus.param.InboundChannelParam;
import org.krproject.ocean.vitamins.param.service.ParamService;
import org.krproject.ocean.vitamins.service.config.ServiceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractInboundActivator<REQ extends OctopusSkeletonOnlineRequest<RESP>, RESP extends OctopusSkeletonOnlineResponse> {
    private static final Logger log = LoggerFactory.getLogger(AbstractInboundActivator.class);
    @Resource
    private Validator validator;
    @Resource
    private ParamService paramService;
    @Resource
    private ServiceProperties serviceProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<AbstractHandler<?, ?>> handlers;
    private static boolean initialized = false;
    private static final Map<String, AbstractHandler<?, ?>> HANDLER_MAP = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.handlers != null) {
                for (AbstractHandler<?, ?> handler : this.handlers) {
                    AbstractHandler<?, ?> handlerFound = HANDLER_MAP.get(handler.getRequestName());
                    if (handlerFound != null) {
                        log.error("handler {} and {} got same request name\uff1a{}", new Object[]{handlerFound, handler, handler.getRequestName()});
                        throw new RuntimeException("duplicate handler for request " + handler.getRequestName());
                    }
                    HANDLER_MAP.put(handler.getRequestName(), handler);
                    log.debug("Loaded Handler:{} for Request:{}", (Object)ClassUtils.getUserClass(handler).getName(), (Object)handler.getRequestName());
                }
            }
            initialized = true;
        }
    }

    public abstract RESP responseWithException(REQ var1, Exception var2);

    public abstract Object insertInbound(String var1, String var2, REQ var3);

    public abstract void updateInbound(Object var1, AbstractHandler<REQ, RESP> var2, RESP var3);

    protected RESP doActivate(String channelId, String channelTxnId, REQ request) throws OctopusBadRequestException, OctopusDuplicatedInboundException {
        if (!StringUtils.hasLength((String)channelId)) {
            log.error("channelId cant't be empty");
            throw new OctopusBadRequestException("channelId cant't be empty");
        }
        if (!StringUtils.hasLength((String)channelTxnId)) {
            log.error("channelTxnId cant't be empty");
            throw new OctopusBadRequestException("channelTxnId cant't be empty");
        }
        if (request == null) {
            log.error("request cant't be null");
            throw new OctopusBadRequestException("request cant't be null");
        }
        if (!(request instanceof OctopusSkeletonOnlineRequest)) {
            log.error("request:{} not instanceof {}", request, OctopusSkeletonOnlineRequest.class);
            throw new OctopusBadRequestException("request instance illegal");
        }
        long requestTime = System.currentTimeMillis();
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation cv = (ConstraintViolation)iterator.next();
            log.error("request validation failed:{}, {}", (Object)cv.getPropertyPath(), (Object)cv.getMessage());
            throw new OctopusBadRequestException(cv.getMessage());
        }
        Object inbound = null;
        try {
            inbound = this.insertInbound(channelId, channelTxnId, request);
        }
        catch (Exception e) {
            throw new OctopusDuplicatedInboundException("duplicated trans, channelId:" + channelId + " channelTxnId:" + channelTxnId, e);
        }
        RESP response = null;
        AbstractHandler<?, ?> handler = null;
        try {
            InboundChannelParam inboundChannel = (InboundChannelParam)this.paramService.getParameter(InboundChannelParam.class, channelId);
            if (inboundChannel == null) {
                log.error("unsupported channel:{}", (Object)channelId);
                throw new OctopusNotPermittedException("unsupported channel:" + channelId);
            }
            log.debug("found parameter of inboundChannel:{}", (Object)inboundChannel);
            String requestClassName = ClassUtils.getUserClass(request).getName();
            if (inboundChannel.getTransControlEnabled().booleanValue() && (inboundChannel.getTransControlPermittedRequests() == null || !inboundChannel.getTransControlPermittedRequests().contains(requestClassName))) {
                log.error("request:{} is not permitted by channel:{}", (Object)requestClassName, (Object)channelId);
                throw new OctopusNotPermittedException("request:" + requestClassName + " is not permitted by channel:" + channelId);
            }
            if (inboundChannel.getFallbackEnabled().booleanValue()) {
                handler = HANDLER_MAP.get(requestClassName + inboundChannel.getFallbackScenario());
                if (handler == null) {
                    log.debug("no mock scenario:{} handler for request:{}, use default!", (Object)inboundChannel.getFallbackScenario(), (Object)requestClassName);
                    handler = HANDLER_MAP.get(requestClassName);
                    if (handler == null) {
                        log.error("fail to get default handler for request:{}", (Object)requestClassName);
                        throw new OctopusSkeletonOnlineException("no default handler for " + requestClassName);
                    }
                }
            } else {
                handler = HANDLER_MAP.get(requestClassName);
                if (handler == null) {
                    log.error("fail to get handler for request:{}", (Object)requestClassName);
                    throw new OctopusSkeletonOnlineException("no handler for " + requestClassName);
                }
            }
            log.debug("found handler:{} for request:{}", handler, request);
            OctopusOnlineContextHolder.clearContext();
            OctopusOnlineContextHolder.getContext().setInboundRequest((OctopusSkeletonOnlineRequest<?>)request);
            OctopusOnlineContextHolder.getContext().setInboundEntity(inbound);
            OctopusOnlineContextHolder.getContext().setInboundHandler(handler);
            response = (RESP)handler.handle(request);
        }
        catch (Exception exception) {
            response = this.responseWithException(request, exception);
        }
        this.updateInbound(inbound, handler, response);
        long responseTime = System.currentTimeMillis();
        this.applicationContext.publishEvent((ApplicationEvent)new HandleCompletedEvent(this, this.serviceProperties.getInstanceId(), (OctopusSkeletonOnlineRequest<?>)request, new Date(requestTime), handler, (OctopusSkeletonOnlineResponse)response, new Date(responseTime)));
        return response;
    }
}

