package org.krproject.ocean.skeletons.octopus.online.context;

import lombok.Data;


/**
 * Octopus联机交易上下文包裹器.
 * 
 * @author Tiger
 */
@Data
public class OctopusOnlineContextHolder {
	
	private static final ThreadLocal<OctopusOnlineContext> contextHolder = new ThreadLocal<OctopusOnlineContext>();
	
	public static void clearContext() {
		contextHolder.remove();
	}
	
	public static void setContext(OctopusOnlineContext context) {
		contextHolder.set(context);
	}

	public static OctopusOnlineContext getContext() {
		OctopusOnlineContext context = contextHolder.get();
		if (contextHolder.get() == null) {
			context = new OctopusOnlineContext();
			contextHolder.set(context);
		}
		return context;
	}
	
}
